<!-- Step 4: Guarantor Information -->
<div class="form-section">
    <h5><i class="fas fa-user-shield"></i> Guarantor Information</h5>
    <p class="text-muted">Provide details of at least one guarantor. A second guarantor is optional but recommended for faster approval.</p>
    
    <div class="alert alert-warning">
        <i class="fas fa-info-circle"></i>
        <strong>Guarantor Requirements:</strong>
        <ul class="mb-0 mt-2">
            <li>Must be a Nigerian citizen with valid ID</li>
            <li>Must be employed or have verifiable source of income</li>
            <li>Should not be a co-applicant on the same property</li>
            <li>Must be willing to sign guarantor form</li>
        </ul>
    </div>
</div>

<!-- Guarantor 1 (Required) -->
<div class="form-section">
    <h5 class="text-primary">
        <i class="fas fa-user"></i> Guarantor 1 (Required)
    </h5>
    
    <div class="row">
        <div class="col-md-6 mb-3">
            <label class="form-label">Full Name <span class="text-danger">*</span></label>
            <input type="text" name="guarantor1_name" class="form-control" required
                   value="<?php echo htmlspecialchars($saved_data['guarantor1_name'] ?? ''); ?>"
                   placeholder="e.g., Chief Adekunle Johnson">
        </div>
        
        <div class="col-md-6 mb-3">
            <label class="form-label">Relationship <span class="text-danger">*</span></label>
            <select name="guarantor1_relationship" class="form-select" required>
                <option value="">Select Relationship</option>
                <option value="parent" <?php echo ($saved_data['guarantor1_relationship'] ?? '') === 'parent' ? 'selected' : ''; ?>>Parent</option>
                <option value="sibling" <?php echo ($saved_data['guarantor1_relationship'] ?? '') === 'sibling' ? 'selected' : ''; ?>>Sibling</option>
                <option value="spouse" <?php echo ($saved_data['guarantor1_relationship'] ?? '') === 'spouse' ? 'selected' : ''; ?>>Spouse</option>
                <option value="relative" <?php echo ($saved_data['guarantor1_relationship'] ?? '') === 'relative' ? 'selected' : ''; ?>>Relative</option>
                <option value="friend" <?php echo ($saved_data['guarantor1_relationship'] ?? '') === 'friend' ? 'selected' : ''; ?>>Friend</option>
                <option value="colleague" <?php echo ($saved_data['guarantor1_relationship'] ?? '') === 'colleague' ? 'selected' : ''; ?>>Colleague</option>
                <option value="other" <?php echo ($saved_data['guarantor1_relationship'] ?? '') === 'other' ? 'selected' : ''; ?>>Other</option>
            </select>
        </div>
    </div>
    
    <div class="row">
        <div class="col-md-6 mb-3">
            <label class="form-label">Phone Number <span class="text-danger">*</span></label>
            <input type="tel" name="guarantor1_phone" class="form-control" required
                   value="<?php echo htmlspecialchars($saved_data['guarantor1_phone'] ?? ''); ?>"
                   placeholder="+234 800 000 0000"
                   pattern="^(\+?234|0)[789]\d{9}$">
        </div>
        
        <div class="col-md-6 mb-3">
            <label class="form-label">Email Address <span class="text-danger">*</span></label>
            <input type="email" name="guarantor1_email" class="form-control" required
                   value="<?php echo htmlspecialchars($saved_data['guarantor1_email'] ?? ''); ?>"
                   placeholder="guarantor@example.com">
        </div>
    </div>
    
    <div class="mb-3">
        <label class="form-label">Residential Address <span class="text-danger">*</span></label>
        <textarea name="guarantor1_address" class="form-control" rows="2" required
                  placeholder="Enter complete residential address"><?php echo htmlspecialchars($saved_data['guarantor1_address'] ?? ''); ?></textarea>
    </div>
    
    <div class="row">
        <div class="col-md-6 mb-3">
            <label class="form-label">Occupation <span class="text-danger">*</span></label>
            <input type="text" name="guarantor1_occupation" class="form-control" required
                   value="<?php echo htmlspecialchars($saved_data['guarantor1_occupation'] ?? ''); ?>"
                   placeholder="e.g., Civil Engineer">
        </div>
        
        <div class="col-md-6 mb-3">
            <label class="form-label">Monthly Income (₦) <span class="text-danger">*</span></label>
            <input type="number" name="guarantor1_income" class="form-control" required min="0" step="1000"
                   value="<?php echo htmlspecialchars($saved_data['guarantor1_income'] ?? ''); ?>"
                   placeholder="e.g., 200000">
        </div>
    </div>
</div>

<!-- Guarantor 2 (Optional) -->
<div class="form-section">
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h5 class="text-secondary mb-0">
            <i class="fas fa-user"></i> Guarantor 2 (Optional)
        </h5>
        <span class="badge bg-success">Recommended</span>
    </div>
    
    <p class="text-muted small">Adding a second guarantor significantly increases your approval chances and speeds up processing time.</p>
    
    <div class="row">
        <div class="col-md-6 mb-3">
            <label class="form-label">Full Name</label>
            <input type="text" name="guarantor2_name" class="form-control"
                   value="<?php echo htmlspecialchars($saved_data['guarantor2_name'] ?? ''); ?>"
                   placeholder="e.g., Mrs. Ngozi Okafor">
        </div>
        
        <div class="col-md-6 mb-3">
            <label class="form-label">Relationship</label>
            <select name="guarantor2_relationship" class="form-select">
                <option value="">Select Relationship</option>
                <option value="parent" <?php echo ($saved_data['guarantor2_relationship'] ?? '') === 'parent' ? 'selected' : ''; ?>>Parent</option>
                <option value="sibling" <?php echo ($saved_data['guarantor2_relationship'] ?? '') === 'sibling' ? 'selected' : ''; ?>>Sibling</option>
                <option value="spouse" <?php echo ($saved_data['guarantor2_relationship'] ?? '') === 'spouse' ? 'selected' : ''; ?>>Spouse</option>
                <option value="relative" <?php echo ($saved_data['guarantor2_relationship'] ?? '') === 'relative' ? 'selected' : ''; ?>>Relative</option>
                <option value="friend" <?php echo ($saved_data['guarantor2_relationship'] ?? '') === 'friend' ? 'selected' : ''; ?>>Friend</option>
                <option value="colleague" <?php echo ($saved_data['guarantor2_relationship'] ?? '') === 'colleague' ? 'selected' : ''; ?>>Colleague</option>
                <option value="other" <?php echo ($saved_data['guarantor2_relationship'] ?? '') === 'other' ? 'selected' : ''; ?>>Other</option>
            </select>
        </div>
    </div>
    
    <div class="row">
        <div class="col-md-6 mb-3">
            <label class="form-label">Phone Number</label>
            <input type="tel" name="guarantor2_phone" class="form-control"
                   value="<?php echo htmlspecialchars($saved_data['guarantor2_phone'] ?? ''); ?>"
                   placeholder="+234 800 000 0000"
                   pattern="^(\+?234|0)[789]\d{9}$">
        </div>
        
        <div class="col-md-6 mb-3">
            <label class="form-label">Email Address</label>
            <input type="email" name="guarantor2_email" class="form-control"
                   value="<?php echo htmlspecialchars($saved_data['guarantor2_email'] ?? ''); ?>"
                   placeholder="guarantor2@example.com">
        </div>
    </div>
    
    <div class="mb-3">
        <label class="form-label">Residential Address</label>
        <textarea name="guarantor2_address" class="form-control" rows="2"
                  placeholder="Enter complete residential address"><?php echo htmlspecialchars($saved_data['guarantor2_address'] ?? ''); ?></textarea>
    </div>
    
    <div class="row">
        <div class="col-md-6 mb-3">
            <label class="form-label">Occupation</label>
            <input type="text" name="guarantor2_occupation" class="form-control"
                   value="<?php echo htmlspecialchars($saved_data['guarantor2_occupation'] ?? ''); ?>"
                   placeholder="e.g., Medical Doctor">
        </div>
        
        <div class="col-md-6 mb-3">
            <label class="form-label">Monthly Income (₦)</label>
            <input type="number" name="guarantor2_income" class="form-control" min="0" step="1000"
                   value="<?php echo htmlspecialchars($saved_data['guarantor2_income'] ?? ''); ?>"
                   placeholder="e.g., 250000">
        </div>
    </div>
</div>

<!-- Guarantor Form Upload -->
<div class="form-section">
    <h5><i class="fas fa-file-signature"></i> Guarantor Form</h5>
    
    <div class="alert alert-info">
        <i class="fas fa-download"></i>
        <strong>Download Guarantor Form:</strong>
        <a href="../assets/forms/guarantor-form.pdf" target="_blank" class="btn btn-sm btn-primary ms-2">
            <i class="fas fa-download"></i> Download PDF Form
        </a>
        <p class="mb-0 mt-2 small">Print this form, have your guarantor(s) fill and sign it, then upload the scanned copy below.</p>
    </div>
    
    <div class="mb-3">
        <label class="form-label">Signed Guarantor Form</label>
        <div class="upload-box" onclick="document.getElementById('guarantorForm').click()">
            <i class="fas fa-file-upload fa-2x text-primary mb-2"></i>
            <p class="mb-0">Click to upload Signed Guarantor Form</p>
            <p class="mb-0 small text-muted">PDF, JPG, PNG (Max 5MB)</p>
        </div>
        <input type="file" id="guarantorForm" name="guarantor_form" class="d-none" 
               accept=".pdf,.jpg,.jpeg,.png">
        <div id="guarantorFormPreview" class="mt-2"></div>
        <small class="text-muted">Upload the completed and signed guarantor form. Optional but highly recommended.</small>
    </div>
</div>

<div class="alert alert-success">
    <i class="fas fa-check-circle"></i> 
    <strong>Almost Done!</strong> Your guarantors will be contacted during the verification process. 
    Please ensure they are aware and willing to confirm their information.
</div>

<style>
    .upload-box {
        border: 2px dashed #ddd;
        border-radius: 10px;
        padding: 20px;
        text-align: center;
        cursor: pointer;
        transition: all 0.3s;
    }
    
    .upload-box:hover {
        border-color: var(--primary);
        background: rgba(212, 160, 23, 0.05);
    }
    
    .file-preview {
        padding: 10px;
        background: #f8f9fa;
        border-radius: 8px;
        border: 1px solid #dee2e6;
    }
</style>

<script>
    // File upload preview
    document.getElementById('guarantorForm').addEventListener('change', function(e) {
        const file = e.target.files[0];
        if (file) {
            if (file.size > 5242880) {
                alert('File size must be less than 5MB');
                this.value = '';
                return;
            }
            
            const icon = file.type.includes('pdf') ? 'fa-file-pdf text-danger' : 'fa-file-image text-primary';
            document.getElementById('guarantorFormPreview').innerHTML = 
                `<div class="file-preview">
                    <i class="fas ${icon} fa-2x"></i>
                    <p class="mb-0 mt-2"><strong>${file.name}</strong></p>
                    <small class="text-muted">${(file.size / 1024 / 1024).toFixed(2)} MB</small>
                    <small class="text-success d-block"><i class="fas fa-check"></i> Ready to upload</small>
                </div>`;
        }
    });
</script>