<!-- Step 2: Identity Verification -->
<div class="form-section">
    <h5><i class="fas fa-id-card"></i> Identity Verification</h5>
    <p class="text-muted">We need to verify your identity using your BVN and government-issued ID.</p>
    
    <div class="row">
        <div class="col-md-6 mb-3">
            <label class="form-label">Bank Verification Number (BVN) <span class="text-danger">*</span></label>
            <input type="text" name="bvn" class="form-control" required
                   value="<?php echo htmlspecialchars($current_user['bvn'] ?? ''); ?>"
                   placeholder="Enter 11-digit BVN" 
                   pattern="\d{11}" 
                   maxlength="11"
                   minlength="11">
            <small class="text-muted">
                <i class="fas fa-lock"></i> Your BVN is encrypted and secure. 
                <a href="#" data-bs-toggle="modal" data-bs-target="#bvnInfoModal">Why do we need this?</a>
            </small>
        </div>
        
        <div class="col-md-6 mb-3">
            <label class="form-label">National Identification Number (NIN)</label>
            <input type="text" name="nin" class="form-control"
                   value="<?php echo htmlspecialchars($current_user['nin'] ?? ''); ?>"
                   placeholder="Enter 11-digit NIN (Optional)" 
                   pattern="\d{11}" 
                   maxlength="11"
                   minlength="11">
            <small class="text-muted">Optional but recommended for faster verification</small>
        </div>
    </div>
</div>

<div class="form-section">
    <h5><i class="fas fa-passport"></i> Government-Issued ID</h5>
    
    <div class="row">
        <div class="col-md-6 mb-3">
            <label class="form-label">ID Type <span class="text-danger">*</span></label>
            <select name="id_type" class="form-select" required id="idType">
                <option value="">Select ID Type</option>
                <option value="international_passport" <?php echo ($saved_data['id_type'] ?? '') === 'international_passport' ? 'selected' : ''; ?>>International Passport</option>
                <option value="national_id" <?php echo ($saved_data['id_type'] ?? '') === 'national_id' ? 'selected' : ''; ?>>National ID Card</option>
                <option value="drivers_license" <?php echo ($saved_data['id_type'] ?? '') === 'drivers_license' ? 'selected' : ''; ?>>Driver's License</option>
                <option value="voters_card" <?php echo ($saved_data['id_type'] ?? '') === 'voters_card' ? 'selected' : ''; ?>>Voter's Card</option>
            </select>
        </div>
        
        <div class="col-md-6 mb-3">
            <label class="form-label">ID Number <span class="text-danger">*</span></label>
            <input type="text" name="id_number" class="form-control" required
                   value="<?php echo htmlspecialchars($saved_data['id_number'] ?? ''); ?>"
                   placeholder="Enter your ID number">
        </div>
    </div>
</div>

<div class="form-section">
    <h5><i class="fas fa-cloud-upload-alt"></i> Upload Documents</h5>
    <p class="text-muted">Please upload clear, readable images of your documents. Max 5MB per file.</p>
    
    <div class="row">
        <div class="col-md-4 mb-3">
            <label class="form-label">ID Card (Front) <span class="text-danger">*</span></label>
            <div class="upload-box" onclick="document.getElementById('idFront').click()">
                <i class="fas fa-upload fa-2x text-primary mb-2"></i>
                <p class="mb-0 small">Click to upload</p>
                <p class="mb-0 small text-muted">JPG, PNG (Max 5MB)</p>
            </div>
            <input type="file" id="idFront" name="id_front_image" class="d-none" accept="image/*" required>
            <div id="idFrontPreview" class="mt-2"></div>
        </div>
        
        <div class="col-md-4 mb-3">
            <label class="form-label">ID Card (Back) <span class="text-danger">*</span></label>
            <div class="upload-box" onclick="document.getElementById('idBack').click()">
                <i class="fas fa-upload fa-2x text-primary mb-2"></i>
                <p class="mb-0 small">Click to upload</p>
                <p class="mb-0 small text-muted">JPG, PNG (Max 5MB)</p>
            </div>
            <input type="file" id="idBack" name="id_back_image" class="d-none" accept="image/*" required>
            <div id="idBackPreview" class="mt-2"></div>
        </div>
        
        <div class="col-md-4 mb-3">
            <label class="form-label">Passport Photo <span class="text-danger">*</span></label>
            <div class="upload-box" onclick="document.getElementById('passport').click()">
                <i class="fas fa-upload fa-2x text-primary mb-2"></i>
                <p class="mb-0 small">Click to upload</p>
                <p class="mb-0 small text-muted">JPG, PNG (Max 5MB)</p>
            </div>
            <input type="file" id="passport" name="passport_photo" class="d-none" accept="image/*" required>
            <div id="passportPreview" class="mt-2"></div>
        </div>
    </div>
</div>

<div class="alert alert-warning">
    <i class="fas fa-shield-alt"></i> 
    <strong>Security & Privacy:</strong> Your BVN will only be used for identity verification through licensed CBN-approved partners. 
    All data is encrypted and NDPR compliant.
</div>

<!-- BVN Info Modal -->
<div class="modal fade" id="bvnInfoModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Why We Need Your BVN</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <p><strong>Your BVN helps us:</strong></p>
                <ul>
                    <li>Verify your identity quickly and securely</li>
                    <li>Prevent fraud and identity theft</li>
                    <li>Comply with regulatory requirements</li>
                    <li>Speed up your application approval</li>
                </ul>
                <p class="mb-0"><strong>We guarantee:</strong></p>
                <ul class="mb-0">
                    <li>Your BVN is encrypted with bank-level security</li>
                    <li>We use licensed CBN-approved verification partners</li>
                    <li>Your data is NDPR compliant and never shared</li>
                    <li>You can delete your account and data anytime</li>
                </ul>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-primary" data-bs-dismiss="modal">I Understand</button>
            </div>
        </div>
    </div>
</div>

<style>
    .upload-box {
        border: 2px dashed #ddd;
        border-radius: 10px;
        padding: 20px;
        text-align: center;
        cursor: pointer;
        transition: all 0.3s;
    }
    
    .upload-box:hover {
        border-color: var(--primary);
        background: rgba(212, 160, 23, 0.05);
    }
    
    .preview-image {
        width: 100%;
        height: 120px;
        object-fit: cover;
        border-radius: 8px;
        border: 2px solid var(--primary);
    }
</style>

<script>
    // Image preview functionality
    function setupImagePreview(inputId, previewId) {
        document.getElementById(inputId).addEventListener('change', function(e) {
            const file = e.target.files[0];
            if (file) {
                if (file.size > 5242880) {
                    alert('File size must be less than 5MB');
                    this.value = '';
                    return;
                }
                
                const reader = new FileReader();
                reader.onload = function(e) {
                    document.getElementById(previewId).innerHTML = 
                        `<img src="${e.target.result}" class="preview-image">
                         <small class="text-success d-block mt-1"><i class="fas fa-check"></i> ${file.name}</small>`;
                };
                reader.readAsDataURL(file);
            }
        });
    }
    
    setupImagePreview('idFront', 'idFrontPreview');
    setupImagePreview('idBack', 'idBackPreview');
    setupImagePreview('passport', 'passportPreview');
</script>