
    // Back to top button
    $(window).scroll(function () {
        if ($(this).scrollTop() > 300) {
            $('.back-to-top').fadeIn('slow');
        } else {
            $('.back-to-top').fadeOut('slow');
        }
    });
    $('.back-to-top').click(function () {
        $('html, body').animate({scrollTop: 0}, 1500, 'easeInOutExpo');
        return false;
    });


    // Header carousel
    $(".header-carousel").owlCarousel({
        autoplay: true,
        smartSpeed: 1500,
        items: 1,
        dots: true,
        loop: true,
        nav : true,
        navText : [
            '<i class="bi bi-chevron-left"></i>',
            '<i class="bi bi-chevron-right"></i>'
        ]
    });
// end here

    // search keyword

    
 document.querySelector("#searchBtn").addEventListener("click", function () {
  let keyword = document.querySelector("#searchKeyword").value.trim();
  let category = document.querySelector("#searchCategory").value;
  let location = document.querySelector("#searchLocation").value;
  let transaction = document.querySelector("#searchTransaction").value;

  if (!category || !location) {
    alert("Please select a category and location before searching.");
    return;
  }

  window.location.href = `search.html?keyword=${encodeURIComponent(keyword)}&category=${category}&location=${location}&transaction=${transaction}`;
});
   /* end */




//    count

document.addEventListener("DOMContentLoaded", function () {
    let counters = document.querySelectorAll('.counter');
    let speed = 250; // Lower is faster

    let options = {
        threshold: 0.5 // Triggers when 50% of the element is visible
    };

    let observer = new IntersectionObserver(function (entries, observer) {
        entries.forEach(entry => {
            if (entry.isIntersecting) {
                let target = entry.target;
                let updateCount = () => {
                    let count = +target.innerText;
                    let maxCount = +target.getAttribute('data-count');
                    let increment = Math.ceil(maxCount / speed);

                    if (count < maxCount) {
                        target.innerText = count + increment;
                        setTimeout(updateCount, 30);
                    } else {
                        target.innerText = maxCount;
                    }
                };
                updateCount();
                observer.unobserve(target); // Stops observing after animation runs
            }
        });
    }, options);

    counters.forEach(counter => {
        observer.observe(counter);
    });
});

// End


// about for Toggle Effect


    document.addEventListener("DOMContentLoaded", function() {
        const toggleButton = document.getElementById("toggle-button");
        const extraContent = document.getElementById("extra-content");
        
        toggleButton.addEventListener("click", function() {
            if (extraContent.style.display === "none") {
                extraContent.style.display = "block";
                toggleButton.innerText = toggleButton.getAttribute("data-lang-en") === "Read More" ? "Read Less" : "Read Less";
            } else {
                extraContent.style.display = "none";
                toggleButton.innerText = toggleButton.getAttribute("data-lang-en") === "Read More" ? "Read More" : "Read More";
            }
        });
    });

// end

// properties listining
document.addEventListener("DOMContentLoaded", function () {
    const buttons = document.querySelectorAll(".filter-btn");
    const cards = document.querySelectorAll(".property-card");

    buttons.forEach(button => {
        button.addEventListener("click", function () {
            const filter = this.getAttribute("data-filter");

            cards.forEach(card => {
                if (filter === "all") {
                    card.classList.remove("hidden");
                } else {
                    card.classList.add("hidden");
                    if (card.classList.contains(filter)) {
                        card.classList.remove("hidden");
                    }
                }
            });
        });
    });
});
// end


    // Testimonials carousel
    $(".testimonial-carousel").owlCarousel({
        autoplay: true,
        smartSpeed: 1000,
        margin: 24,
        dots: false,
        loop: true,
        nav : true,
        navText : [
            '<i class="bi bi-arrow-left"></i>',
            '<i class="bi bi-arrow-right"></i>'
        ],
        responsive: {
            0:{
                items:1
            },
            992:{
                items:2
            }
        }
    });
    


    // Tooltip Social media links
   
        document.addEventListener('DOMContentLoaded', function () {
          var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
          tooltipTriggerList.forEach(function (tooltipTriggerEl) {
            new bootstrap.Tooltip(tooltipTriggerEl);
          });
        });
     