
const properties = {
1: {
title: "Luxury Home in Lagos",
image: "img/property-1.jpg",
description: "A premium villa in the heart of Victoria Island, Lagos.",
price: "₦120,000,000",
location: "Victoria Island, Lagos, Nigeria",
size: "800 Sqm",
bedrooms: "4",
bathrooms: "3",
coordinates: { lat: 6.4281, lng: 3.4215 },
surveyDoc: "docs/survey-lagos.pdf"
},
2: {
title: "Modern Apartment in Abuja",
image: "img/property-2.jpg",
description: "A fully furnished apartment in the center of Abuja.",
price: "₦85,000,000",
location: "Maitama, Abuja, Nigeria",
size: "600 Sqm",
bedrooms: "3",
bathrooms: "2",
coordinates: { lat: 9.05785, lng: 7.49508 },
surveyDoc: "docs/survey-abuja.pdf"
},
3: {
title: "Golden Urban House For Rent",
image: "img/property-4.jpg",
description: "A stunning urban villa available for rent in New York.",
price: "$12,345",
location: "123 Street, New York, USA",
size: "1000 Sqft",
bedrooms: "3",
bathrooms: "2",
coordinates: { lat: 40.7128, lng: -74.0060 },
surveyDoc: "docs/survey-ny.pdf"
}
};

function getQueryParam(param) {
const urlParams = new URLSearchParams(window.location.search);
return urlParams.get(param);
}

const propertyId = getQueryParam("id");

if (propertyId && properties[propertyId]) {
const property = properties[propertyId];
document.getElementById("property-title").innerText = property.title;
document.getElementById("property-image").src = property.image;
document.getElementById("property-description").innerText = property.description;
document.getElementById("property-price").innerText = property.price;
document.getElementById("property-location").innerText = property.location;
document.getElementById("property-size").innerText = property.size;
document.getElementById("property-bedrooms").innerText = property.bedrooms;
document.getElementById("property-bathrooms").innerText = property.bathrooms;
document.getElementById("property-coordinates").innerText = `${property.coordinates.lat}, ${property.coordinates.lng}`;

// Google Maps Embed
const mapIframe = document.getElementById("property-map");
mapIframe.src = `https://www.google.com/maps?q=${property.coordinates.lat},${property.coordinates.lng}&output=embed`;

// Update Survey Link
document.getElementById("survey-link").href = `payment.html?id=${propertyId}`;

} else {
document.querySelector(".container").innerHTML = "<h1>Property Not Found</h1>";
}

