<?php
if (!defined('ROVO_APP')) {
    die('Direct access not permitted');
}

$current_user = $auth->getCurrentUser();
if (!$current_user) {
    header('Location: ../login.php');
    exit;
}

$current_page = basename($_SERVER['PHP_SELF'], '.php');
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $page_title ?? 'Admin Dashboard'; ?> - RoVo Nigeria</title>
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.7.2/css/all.min.css" rel="stylesheet">
    
    <!-- Chart.js -->
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    
    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    
    <!-- SweetAlert2 -->
    <link href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@700&family=Inter:wght@400;500;600&display=swap" rel="stylesheet">
    
    <link rel="icon" type="image/png" sizes="32x32" href="../favicon/favicon-32x32.png">
    
    <style>
        :root {
            --primary: #D4A017;
            --secondary: #B8974A;
            --sidebar-width: 260px;
            --header-height: 70px;
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Inter', sans-serif;
            background: #f5f7fa;
            overflow-x: hidden;
        }
        
        /* Sidebar */
        .sidebar {
            position: fixed;
            top: 0;
            left: 0;
            width: var(--sidebar-width);
            height: 100vh;
            background: linear-gradient(180deg, #2A2A2A 0%, #1a1a1a 100%);
            padding: 20px 0;
            overflow-y: auto;
            transition: transform 0.3s ease;
            z-index: 1000;
        }
        
        .sidebar.active {
            transform: translateX(0);
        }
        
        .sidebar-brand {
            padding: 0 20px 30px;
            border-bottom: 1px solid rgba(255,255,255,0.1);
            text-align: center;
        }
        
        .sidebar-brand h3 {
            color: var(--primary);
            font-family: 'Playfair Display', serif;
            font-size: 2rem;
            margin: 0;
        }
        
        .sidebar-brand p {
            color: #999;
            font-size: 0.85rem;
            margin: 5px 0 0;
        }
        
        .sidebar-menu {
            padding: 20px 0;
        }
        
        .menu-section {
            padding: 10px 20px;
            color: #666;
            font-size: 0.75rem;
            text-transform: uppercase;
            font-weight: 600;
            letter-spacing: 1px;
        }
        
        .sidebar-menu a {
            display: flex;
            align-items: center;
            padding: 12px 20px;
            color: #ccc;
            text-decoration: none;
            transition: all 0.3s;
            border-left: 3px solid transparent;
        }
        
        .sidebar-menu a:hover {
            background: rgba(212, 160, 23, 0.1);
            color: var(--primary);
            border-left-color: var(--primary);
        }
        
        .sidebar-menu a.active {
            background: rgba(212, 160, 23, 0.15);
            color: var(--primary);
            border-left-color: var(--primary);
            font-weight: 600;
        }
        
        .sidebar-menu a i {
            width: 24px;
            margin-right: 12px;
            font-size: 1.1rem;
        }
        
        /* Header */
        .main-header {
            position: fixed;
            top: 0;
            left: var(--sidebar-width);
            right: 0;
            height: var(--header-height);
            background: white;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            display: flex;
            align-items: center;
            justify-content: space-between;
            padding: 0 30px;
            z-index: 999;
            transition: left 0.3s ease;
        }
        
        .menu-toggle {
            display: none;
            background: none;
            border: none;
            font-size: 1.5rem;
            color: #333;
            cursor: pointer;
        }
        
        .header-left {
            display: flex;
            align-items: center;
            gap: 20px;
        }
        
        .header-right {
            display: flex;
            align-items: center;
            gap: 20px;
        }
        
        .notification-icon {
            position: relative;
            font-size: 1.3rem;
            color: #666;
            cursor: pointer;
            transition: color 0.3s;
        }
        
        .notification-icon:hover {
            color: var(--primary);
        }
        
        .notification-badge {
            position: absolute;
            top: -8px;
            right: -8px;
            background: #dc3545;
            color: white;
            border-radius: 50%;
            width: 18px;
            height: 18px;
            font-size: 0.7rem;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        .user-dropdown {
            display: flex;
            align-items: center;
            gap: 12px;
            cursor: pointer;
            padding: 8px 15px;
            border-radius: 25px;
            transition: background 0.3s;
        }
        
        .user-dropdown:hover {
            background: #f5f7fa;
        }
        
        .user-avatar {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            background: var(--primary);
            color: white;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: 600;
        }
        
        .user-info {
            display: flex;
            flex-direction: column;
        }
        
        .user-info strong {
            font-size: 0.9rem;
            color: #333;
        }
        
        .user-info small {
            font-size: 0.75rem;
            color: #999;
        }
        
        /* Main Content */
        .main-content {
            margin-left: var(--sidebar-width);
            margin-top: var(--header-height);
            padding: 30px;
            min-height: calc(100vh - var(--header-height));
            transition: margin-left 0.3s ease;
        }
        
        /* Page Header */
        .page-header {
            margin-bottom: 30px;
        }
        
        .page-header h1 {
            font-family: 'Playfair Display', serif;
            color: #2A2A2A;
            margin-bottom: 10px;
        }
        
        .breadcrumb {
            background: none;
            padding: 0;
            margin: 0;
        }
        
        /* Cards */
        .card {
            border: none;
            border-radius: 15px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.08);
            margin-bottom: 30px;
            transition: transform 0.3s, box-shadow 0.3s;
        }
        
        .card:hover {
            transform: translateY(-5px);
            box-shadow: 0 5px 20px rgba(0,0,0,0.12);
        }
        
        .card-header {
            background: white;
            border-bottom: 1px solid #e0e0e0;
            padding: 20px;
            border-radius: 15px 15px 0 0;
        }
        
        /* Statistics Cards */
        .stat-card {
            padding: 25px;
            display: flex;
            align-items: center;
            justify-content: space-between;
        }
        
        .stat-icon {
            width: 60px;
            height: 60px;
            border-radius: 15px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.8rem;
        }
        
        .stat-info h3 {
            font-size: 2rem;
            font-weight: 700;
            margin-bottom: 5px;
            color: #2A2A2A;
        }
        
        .stat-info p {
            color: #666;
            margin-bottom: 8px;
        }
        
        .stat-trend {
            font-size: 0.85rem;
            color: #28a745;
        }
        
        .stat-trend.up {
            color: #28a745;
        }
        
        .stat-trend.down {
            color: #dc3545;
        }
        
        /* Mobile Overlay */
        .sidebar-overlay {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(0,0,0,0.5);
            z-index: 999;
            opacity: 0;
            transition: opacity 0.3s ease;
        }
        
        .sidebar-overlay.active {
            opacity: 1;
        }
        
        /* Mobile Styles */
        @media (max-width: 768px) {
            .sidebar {
                transform: translateX(-100%);
            }
            
            .sidebar.active {
                transform: translateX(0);
            }
            
            .main-header {
                left: 0;
            }
            
            .main-content {
                margin-left: 0;
            }
            
            .menu-toggle {
                display: block;
            }
            
            .sidebar-overlay {
                display: block;
            }
            
            .user-info {
                display: none;
            }
            
            .page-header h1 {
                font-size: 1.5rem;
            }
        }
        
        @media (max-width: 576px) {
            .main-content {
                padding: 15px;
            }
            
            .stat-card {
                padding: 15px;
            }
            
            .stat-icon {
                width: 50px;
                height: 50px;
                font-size: 1.5rem;
            }
            
            .stat-info h3 {
                font-size: 1.5rem;
            }
        }
    </style>
</head>
<body>
    <!-- Sidebar Overlay (for mobile) -->
    <div class="sidebar-overlay" id="sidebarOverlay"></div>
    
    <!-- Sidebar -->
    <aside class="sidebar" id="sidebar">
        <div class="sidebar-brand">
            <h3>RoVo</h3>
            <p>Admin Dashboard</p>
        </div>
        
        <nav class="sidebar-menu">
            <div class="menu-section">Main</div>
            <a href="dashboard.php" class="<?php echo $current_page === 'dashboard' ? 'active' : ''; ?>">
                <i class="fas fa-th-large"></i>
                <span>Dashboard</span>
            </a>
            
            <?php if ($auth->hasPermission('can_manage_properties') || $auth->hasRole('super_admin')): ?>
            <div class="menu-section">Property Management</div>
            <a href="properties.php" class="<?php echo $current_page === 'properties' || $current_page === 'property-form' ? 'active' : ''; ?>">
                <i class="fas fa-building"></i>
                <span>Properties</span>
            </a>
            <a href="lands.php" class="<?php echo $current_page === 'lands' || $current_page === 'land-form' ? 'active' : ''; ?>">
                <i class="fas fa-map-marked-alt"></i>
                <span>Lands</span>
            </a>
            <a href="materials.php" class="<?php echo $current_page === 'materials' || $current_page === 'material-form' ? 'active' : ''; ?>">
                <i class="fas fa-boxes"></i>
                <span>Building Materials</span>
            </a>
            <?php endif; ?>
            
            <div class="menu-section">Applications</div>
            <a href="rental-applications.php" class="<?php echo $current_page === 'rental-applications' ? 'active' : ''; ?>">
                <i class="fas fa-file-alt"></i>
                <span>Rental Applications</span>
            </a>
            <a href="sell-applications.php" class="<?php echo $current_page === 'sell-applications' ? 'active' : ''; ?>">
                <i class="fas fa-handshake"></i>
                <span>Sell Applications</span>
            </a>
            
            <?php if ($auth->hasPermission('can_verify_documents') || $auth->hasRole('super_admin')): ?>
            <a href="document-verification.php" class="<?php echo $current_page === 'document-verification' ? 'active' : ''; ?>">
                <i class="fas fa-certificate"></i>
                <span>Document Verification</span>
            </a>
            <?php endif; ?>
            
            <?php if ($auth->hasPermission('can_manage_payments') || $auth->hasRole('super_admin')): ?>
            <div class="menu-section">Financial</div>
            <a href="payments.php" class="<?php echo $current_page === 'payments' ? 'active' : ''; ?>">
                <i class="fas fa-credit-card"></i>
                <span>Payments</span>
            </a>
            <?php endif; ?>
            
            <?php if ($auth->hasPermission('can_manage_users') || $auth->hasRole('super_admin')): ?>
            <div class="menu-section">User Management</div>
            <a href="users.php" class="<?php echo $current_page === 'users' ? 'active' : ''; ?>">
                <i class="fas fa-users"></i>
                <span>Users</span>
            </a>
            <a href="admins.php" class="<?php echo $current_page === 'admins' ? 'active' : ''; ?>">
                <i class="fas fa-user-shield"></i>
                <span>Admin Management</span>
            </a>
            <?php endif; ?>
            
            <div class="menu-section">Content</div>
            <a href="blog.php" class="<?php echo $current_page === 'blog' || $current_page === 'blog-form' ? 'active' : ''; ?>">
                <i class="fas fa-newspaper"></i>
                <span>Blog</span>
            </a>
            <a href="contact-messages.php" class="<?php echo $current_page === 'contact-messages' ? 'active' : ''; ?>">
                <i class="fas fa-envelope"></i>
                <span>Contact Messages</span>
            </a>
            
            <div class="menu-section">System</div>
            <a href="activity-logs.php" class="<?php echo $current_page === 'activity-logs' ? 'active' : ''; ?>">
                <i class="fas fa-history"></i>
                <span>Activity Logs</span>
            </a>
            <a href="settings.php" class="<?php echo $current_page === 'settings' ? 'active' : ''; ?>">
                <i class="fas fa-cog"></i>
                <span>Settings</span>
            </a>
        </nav>
    </aside>
    
    <!-- Main Header -->
    <header class="main-header">
        <div class="header-left">
            <button class="menu-toggle" id="menuToggle">
                <i class="fas fa-bars"></i>
            </button>
            <h2 style="margin: 0; font-size: 1.2rem; color: #333;">
                <?php echo $page_title ?? 'Dashboard'; ?>
            </h2>
        </div>
        
        <div class="header-right">
            <a href="notifications.php" class="notification-icon">
                <i class="far fa-bell"></i>
                <span class="notification-badge">5</span>
            </a>
            
            <div class="dropdown">
                <div class="user-dropdown" data-bs-toggle="dropdown">
                    <div class="user-avatar">
                        <?php echo strtoupper(substr($current_user['first_name'], 0, 1) . substr($current_user['last_name'], 0, 1)); ?>
                    </div>
                    <div class="user-info">
                        <strong><?php echo htmlspecialchars($current_user['first_name']); ?></strong>
                        <small><?php echo ucfirst(str_replace('_', ' ', $current_user['role'])); ?></small>
                    </div>
                    <i class="fas fa-chevron-down"></i>
                </div>
                <ul class="dropdown-menu dropdown-menu-end">
                    <li><a class="dropdown-item" href="profile.php"><i class="fas fa-user me-2"></i> Profile</a></li>
                    <li><a class="dropdown-item" href="settings.php"><i class="fas fa-cog me-2"></i> Settings</a></li>
                    <li><hr class="dropdown-divider"></li>
                    <li><a class="dropdown-item" href="../logout.php"><i class="fas fa-sign-out-alt me-2"></i> Logout</a></li>
                </ul>
            </div>
        </div>
    </header>
    
    <!-- Main Content -->
    <main class="main-content">

<script>
// Mobile menu toggle
document.addEventListener('DOMContentLoaded', function() {
    const menuToggle = document.getElementById('menuToggle');
    const sidebar = document.getElementById('sidebar');
    const sidebarOverlay = document.getElementById('sidebarOverlay');
    
    menuToggle.addEventListener('click', function() {
        sidebar.classList.toggle('active');
        sidebarOverlay.classList.toggle('active');
    });
    
    sidebarOverlay.addEventListener('click', function() {
        sidebar.classList.remove('active');
        sidebarOverlay.classList.remove('active');
    });
    
    // Close sidebar when clicking a link on mobile
    if (window.innerWidth <= 768) {
        const sidebarLinks = sidebar.querySelectorAll('a');
        sidebarLinks.forEach(link => {
            link.addEventListener('click', function() {
                sidebar.classList.remove('active');
                sidebarOverlay.classList.remove('active');
            });
        });
    }
});
</script>