
<?php
// ==========================================
// FILE: admin/ajax/get-application-details.php
// ==========================================
/* Save as: admin/ajax/get-application-details.php */
define('ROVO_APP', true);
require_once '../../config.php';
require_once '../../Auth.php';

if (!$auth->isAdmin()) {
    die('Unauthorized');
}

$app_id = (int)($_GET['id'] ?? 0);

$sql = "SELECT ra.*, u.email, u.phone, rp.name as package_name
        FROM rental_applications ra
        LEFT JOIN users u ON ra.user_id = u.id
        LEFT JOIN rental_packages rp ON ra.package_id = rp.id
        WHERE ra.id = ?";

$app = $db->fetchOne($sql, [$app_id]);

if (!$app) {
    die('Application not found');
}
?>

<div class="row">
    <div class="col-md-6">
        <h6>Personal Information</h6>
        <table class="table table-sm table-bordered">
            <tr>
                <td><strong>Application #:</strong></td>
                <td><?php echo htmlspecialchars($app['application_number']); ?></td>
            </tr>
            <tr>
                <td><strong>Full Name:</strong></td>
                <td><?php echo htmlspecialchars($app['full_name']); ?></td>
            </tr>
            <tr>
                <td><strong>Email:</strong></td>
                <td><?php echo htmlspecialchars($app['email']); ?></td>
            </tr>
            <tr>
                <td><strong>Phone:</strong></td>
                <td><?php echo htmlspecialchars($app['phone']); ?></td>
            </tr>
            <tr>
                <td><strong>Date of Birth:</strong></td>
                <td><?php echo $app['date_of_birth'] ? date('M d, Y', strtotime($app['date_of_birth'])) : 'N/A'; ?></td>
            </tr>
            <tr>
                <td><strong>BVN:</strong></td>
                <td><?php echo htmlspecialchars($app['bvn'] ?? 'Not provided'); ?></td>
            </tr>
            <tr>
                <td><strong>NIN:</strong></td>
                <td><?php echo htmlspecialchars($app['nin'] ?? 'Not provided'); ?></td>
            </tr>
        </table>
    </div>
    
    <div class="col-md-6">
        <h6>Employment Information</h6>
        <table class="table table-sm table-bordered">
            <tr>
                <td><strong>Employment Status:</strong></td>
                <td><?php echo htmlspecialchars($app['employment_status'] ?? 'N/A'); ?></td>
            </tr>
            <tr>
                <td><strong>Company:</strong></td>
                <td><?php echo htmlspecialchars($app['company_name'] ?? 'N/A'); ?></td>
            </tr>
            <tr>
                <td><strong>Job Title:</strong></td>
                <td><?php echo htmlspecialchars($app['job_title'] ?? 'N/A'); ?></td>
            </tr>
            <tr>
                <td><strong>Monthly Income:</strong></td>
                <td>₦<?php echo number_format($app['monthly_income'] ?? 0); ?></td>
            </tr>
        </table>
        
        <h6>Rental Details</h6>
        <table class="table table-sm table-bordered">
            <tr>
                <td><strong>Package:</strong></td>
                <td><?php echo htmlspecialchars($app['package_name'] ?? 'N/A'); ?></td>
            </tr>
            <tr>
                <td><strong>Annual Rent:</strong></td>
                <td><strong>₦<?php echo number_format($app['annual_rent']); ?></strong></td>
            </tr>
            <tr>
                <td><strong>Monthly Payment:</strong></td>
                <td>₦<?php echo number_format($app['total_monthly_payment']); ?></td>
            </tr>
            <tr>
                <td><strong>Lease Duration:</strong></td>
                <td><?php echo $app['lease_duration']; ?> months</td>
            </tr>
            <tr>
                <td><strong>Move-in Date:</strong></td>
                <td><?php echo date('M d, Y', strtotime($app['move_in_date'])); ?></td>
            </tr>
        </table>
    </div>
</div>

<div class="row mt-3">
    <div class="col-12">
        <h6>Guarantor Information</h6>
        <table class="table table-sm table-bordered">
            <tr>
                <td><strong>Guarantor 1:</strong></td>
                <td><?php echo htmlspecialchars($app['guarantor1_name'] ?? 'N/A'); ?></td>
                <td><?php echo htmlspecialchars($app['guarantor1_phone'] ?? ''); ?></td>
                <td><?php echo htmlspecialchars($app['guarantor1_relationship'] ?? ''); ?></td>
            </tr>
            <?php if ($app['guarantor2_name']): ?>
            <tr>
                <td><strong>Guarantor 2:</strong></td>
                <td><?php echo htmlspecialchars($app['guarantor2_name']); ?></td>
                <td><?php echo htmlspecialchars($app['guarantor2_phone'] ?? ''); ?></td>
                <td><?php echo htmlspecialchars($app['guarantor2_relationship'] ?? ''); ?></td>
            </tr>
            <?php endif; ?>
        </table>
    </div>
</div>

<?php if ($app['admin_notes']): ?>
<div class="alert alert-info">
    <strong>Admin Notes:</strong> <?php echo nl2br(htmlspecialchars($app['admin_notes'])); ?>
</div>
<?php endif; ?>

<?php if ($app['rejection_reason']): ?>
<div class="alert alert-danger">
    <strong>Rejection Reason:</strong> <?php echo nl2br(htmlspecialchars($app['rejection_reason'])); ?>
</div>
<?php endif; ?>