
<?php
// ==========================================
// FILE: admin/ajax/get-admin-permissions.php
// ==========================================
/* Save as: admin/ajax/get-admin-permissions.php */
define('ROVO_APP', true);
require_once '../../config.php';
require_once '../../Auth.php';

if (!$auth->hasRole('super_admin')) {
    die(json_encode(['error' => 'Unauthorized']));
}

header('Content-Type: application/json');

$admin_id = (int)($_GET['id'] ?? 0);

$sql = "SELECT * FROM admin_permissions WHERE admin_id = ?";
$permissions = $db->fetchOne($sql, [$admin_id]);

if (!$permissions) {
    // Return default permissions if none exist
    $permissions = [
        'can_create' => 0,
        'can_edit' => 0,
        'can_delete' => 0,
        'can_view' => 1,
        'can_manage_users' => 0,
        'can_manage_payments' => 0,
        'can_manage_properties' => 0,
        'can_verify_documents' => 0
    ];
}

echo json_encode($permissions);
